import { getServerSession } from "next-auth/next";
import { authOptions } from "@/app/api/auth/[...nextauth]/route";
import EditAnnonceForm from "./EditAnnonceForm";
import { getAnnonceById, getAnnonceByIdInclude } from "@/lib/services/annonceService";
import EditAnnonceMainImg from "./EditAnnonceMainImg";
import EditAnnonceOtherImg from "./EditAnnonceOhterImg";
import { AnnonceProps } from "@/lib/types/AnnonceProps";

export default async function EditAnnoncePage({ params }: { params: { id: string } }) {
    const session = await getServerSession(authOptions);
    if (!session || session.user?.role === "USER") {
        return (
            <div className="flex min-h-screen flex-col items-center justify-center p-4">
                <div className="mx-auto w-full max-w-md text-center">
                    <h2 className="mb-4 text-2xl font-bold text-gray-900">Accès refusé</h2>
                    <p className="mb-6 text-gray-600">
                        Vous devez être connecté en tant qu'agent immobilier pour ajouter une annonce.
                    </p>
                </div>
            </div>
        );
    }
    const annonceId = params.id;
    const annonce = await getAnnonceByIdInclude(parseInt(annonceId));

    return <div>
        <EditAnnonceForm annonce={annonce as AnnonceProps} ></EditAnnonceForm>
        <EditAnnonceMainImg annonce={annonce as AnnonceProps}></EditAnnonceMainImg>
        <EditAnnonceOtherImg annonceId={Number(annonceId) as number} annonceGallery={ annonce?.autresImages }></EditAnnonceOtherImg>
    </div>
}
